/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.client;

import sk.singularisdev.ekasask.utils.Utility;

public class Transaction {

    public static class ID
    implements Comparable<ID> {
        private static final int TRANSACTION_PER_DIR = 25;
        public static final ID ID_0 = new ID(0, 0);
        private int dirSeq;
        private int transSeq;

        public ID(int dirSeq, int transSeq) {
            this.dirSeq = dirSeq;
            this.transSeq = transSeq;
        }

        public ID(String idString) {
            this.parse(idString);
        }

        public void setId(int dirSeq, int transSeq) {
            this.dirSeq = dirSeq;
            this.transSeq = transSeq;
        }

        public void setId(ID transactionId) {
            this.dirSeq = transactionId.dirSeq;
            this.transSeq = transactionId.transSeq;
        }

        public void increment() {
            ++this.transSeq;
            if (this.transSeq % 25 == 0 && this.transSeq > 0) {
                ++this.dirSeq;
            }
        }

        public void decrement() {
            if (this.transSeq % 25 == 0 && this.transSeq > 0) {
                --this.dirSeq;
            }
            --this.transSeq;
        }

        public String format() {
            return String.format("%1$06d%2$08d", this.dirSeq, this.transSeq);
        }

        public void parse(String id) {
            if (id.length() == 0) {
                this.dirSeq = 0;
                this.transSeq = 0;
            } else {
                id = id.replace(".", "");
                this.dirSeq = Integer.parseInt(id.substring(0, 6));
                this.transSeq = Integer.parseInt(id.substring(6));
            }
        }

        @Override
        public int compareTo(ID other) {
            if (this.dirSeq == other.dirSeq) {
                return Utility.compare((int)this.transSeq, (int)other.transSeq);
            }
            return Utility.compare((int)this.dirSeq, (int)other.dirSeq);
        }
    }
}

