/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.client.application;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.UIManager;
import sk.singularisdev.ekasask.client.Transaction;
import sk.singularisdev.ekasask.client.application.AbstractTrayIcon;
import sk.singularisdev.ekasask.client.application.CommunicationClient;
import sk.singularisdev.ekasask.client.application.Configuration;
import sk.singularisdev.ekasask.client.application.FiscalModule;
import sk.singularisdev.ekasask.client.application.PpekkStateListener;
import sk.singularisdev.ekasask.client.application.StatusThread;
import sk.singularisdev.ekasask.client.application.TrayIconAWT;
import sk.singularisdev.ekasask.client.application.TrayIconJDIC;
import sk.singularisdev.ekasask.client.application.TrayPopupMenuAWT;
import sk.singularisdev.ekasask.client.application.TrayPopupMenuJDIC;
import sk.singularisdev.ekasask.client.localization.Localization;
import sk.singularisdev.ekasask.client.packet.CfgQuorionBridgeRequest;
import sk.singularisdev.ekasask.client.packet.CfgQuorionBridgeResponse;
import sk.singularisdev.ekasask.client.packet.ChduConnectRequest;
import sk.singularisdev.ekasask.client.packet.ChduConnectResponse;
import sk.singularisdev.ekasask.client.packet.ChduDisconnectRequest;
import sk.singularisdev.ekasask.client.packet.ChduDisconnectResponse;
import sk.singularisdev.ekasask.client.packet.GetCertificateValidRequest;
import sk.singularisdev.ekasask.client.packet.GetCertificateValidResponse;
import sk.singularisdev.ekasask.client.packet.GetChduInfoRequest;
import sk.singularisdev.ekasask.client.packet.GetChduInfoResponse;
import sk.singularisdev.ekasask.client.packet.GetChduStateRequest;
import sk.singularisdev.ekasask.client.packet.GetChduStateResponse;
import sk.singularisdev.ekasask.client.packet.GetPpekkInfoRequest;
import sk.singularisdev.ekasask.client.packet.GetPpekkInfoResponse;
import sk.singularisdev.ekasask.client.packet.GetPpekkRs232PortRequest;
import sk.singularisdev.ekasask.client.packet.GetPpekkRs232PortResponse;
import sk.singularisdev.ekasask.client.packet.GetUnsendedMessageRequest;
import sk.singularisdev.ekasask.client.packet.GetUnsendedMessageResponse;
import sk.singularisdev.ekasask.client.packet.LoadPacketFromChduRequest;
import sk.singularisdev.ekasask.client.packet.LoadPacketFromChduResponse;
import sk.singularisdev.ekasask.client.packet.PrintLastReceiptCopyMessageRequest;
import sk.singularisdev.ekasask.client.packet.PrintLastReceiptCopyMessageResponse;
import sk.singularisdev.ekasask.client.packet.PrintUnsendedMessageRequest;
import sk.singularisdev.ekasask.client.packet.PrintUnsendedMessageResponse;
import sk.singularisdev.ekasask.client.packet.SendUnsendedMessageRequest;
import sk.singularisdev.ekasask.client.packet.SendUnsendedMessageResponse;
import sk.singularisdev.ekasask.client.packet.SendUpgradeRequest;
import sk.singularisdev.ekasask.client.packet.SendUpgradeResponse;
import sk.singularisdev.ekasask.client.packet.SetAuthenticationRequest;
import sk.singularisdev.ekasask.client.packet.SetAuthenticationResponse;
import sk.singularisdev.ekasask.client.packet.SetChduPortRequest;
import sk.singularisdev.ekasask.client.packet.SetChduPortResponse;
import sk.singularisdev.ekasask.client.packet.SetIdentityRequest;
import sk.singularisdev.ekasask.client.packet.SetIdentityResponse;
import sk.singularisdev.ekasask.client.packet.SetProxyRequest;
import sk.singularisdev.ekasask.client.packet.SetProxyResponse;
import sk.singularisdev.ekasask.client.packet.SynchronizeRequest;
import sk.singularisdev.ekasask.client.packet.SynchronizeResponse;
import sk.singularisdev.ekasask.client.packet.TestReceiptRequest;
import sk.singularisdev.ekasask.client.packet.TestReceiptResponse;
import sk.singularisdev.ekasask.client.ui.PPEKKWindow;

public class Controller {
    public static boolean QUORION_BRIDGE = false;
    private static final String CONFIG_FILEPATH = "ppekk_client.config";
    private AbstractTrayIcon trayIcon;
    private Configuration configuration;
    private CommunicationClient commClient;
    private StatusThread statusThread;
    private boolean connected = false;
    private Map<Integer, GetPpekkInfoResponse> ppekkInfo = new HashMap<Integer, GetPpekkInfoResponse>();
    private List<PpekkStateListener> ppekkStateListeners = new ArrayList<PpekkStateListener>();
    private boolean notray = false;
    private int deviceId = 1;
    private String serverAddress = "localhost";
    private int serverPort = 30000;
    private String proxyHost;
    private int proxyPort;
    private PPEKKWindow ppekkWindow = null;
    public static File LAST_DIR = new File("");

    public void addPpekkStateListener(PpekkStateListener listener) {
        this.ppekkStateListeners.add(listener);
    }

    public void exit() {
        if (!this.notray) {
            this.saveConfiguration(CONFIG_FILEPATH);
        }
        if (this.statusThread != null) {
            this.statusThread.stopThread();
        }
        if (this.trayIcon != null) {
            this.trayIcon.dispose();
        }
        System.exit(0);
    }

    public void init() {
        this.configuration = new Configuration();
        this.loadConfiguration(CONFIG_FILEPATH);
        if (this.notray) {
            this.configuration.setServerAddress(this.serverAddress);
            this.configuration.setServerPort(this.serverPort);
            this.configuration.setActiveDevice(this.deviceId);
            this.configuration.setDevices(new int[]{this.deviceId});
            this.commClient = new CommunicationClient(this);
            this.commClient.setConfiguration(this.configuration);
            this.statusThread = new StatusThread(this, this.commClient);
            this.statusThread.startThread();
            this.ppekkWindow = new PPEKKWindow(this, true);
        } else {
            try {
                Class.forName("java.awt.SystemTray");
                this.trayIcon = new TrayIconAWT();
                new TrayPopupMenuAWT((TrayIconAWT)this.trayIcon, this);
            }
            catch (Throwable e1) {
                this.trayIcon = new TrayIconJDIC();
                new TrayPopupMenuJDIC((TrayIconJDIC)this.trayIcon, this);
            }
            if (this.trayIcon != null) {
                this.trayIcon.register();
            }
            this.commClient = new CommunicationClient(this);
            this.commClient.setConfiguration(this.configuration);
            this.statusThread = new StatusThread(this, this.commClient);
            this.statusThread.startThread();
        }
    }

    public static void main(String[] args) {
        FileInputStream in = null;
        try {
            String filename = "ui.pid";
            File f = new File(filename);
            f.delete();
            f.createNewFile();
            in = new FileInputStream(f);
            RandomAccessFile raf = new RandomAccessFile(f, "rw");
            FileLock lock = raf.getChannel().tryLock();
            if (lock == null) {
                System.out.println("Be\u017e\u00ed in\u00e1 in\u0161tancia.");
                return;
            }
            try {
                try {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Locale currentLocale = new Locale("sk");
                Localization.setBundle(ResourceBundle.getBundle("sk.singularisdev.ekasask.client.localization.ekasask", currentLocale));
                Controller controller = new Controller();
                controller.notray = false;
                int i = 0;
                while (i < args.length) {
                    if (args[i].equalsIgnoreCase("-notray")) {
                        controller.notray = true;
                    } else if (args[i].equalsIgnoreCase("-deviceid")) {
                        if (args.length > ++i) {
                            controller.deviceId = Integer.parseInt(args[i]);
                        }
                    } else if (args[i].equalsIgnoreCase("-ip")) {
                        if (args.length > ++i) {
                            controller.serverAddress = args[i];
                        }
                    } else if (args[i].equalsIgnoreCase("-port")) {
                        if (args.length > ++i) {
                            controller.serverPort = Integer.parseInt(args[i]);
                        }
                    } else if (args[i].startsWith("-proxy:")) {
                        String[] proxy = args[i].split(":");
                        controller.proxyHost = proxy[1];
                        controller.proxyPort = Integer.parseInt(proxy[2]);
                    } else if (args[i].equalsIgnoreCase("-bridge=quorion")) {
                        QUORION_BRIDGE = true;
                    }
                    ++i;
                }
                controller.init();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void serverConnected(boolean connected) {
        this.connected = connected;
        if (this.trayIcon != null) {
            this.trayIcon.setConnectionState(connected ? CONNECTION_STATE.CONNECTED : CONNECTION_STATE.DISCONNECTED);
        }
    }

    public boolean isServerConnected() {
        return this.connected;
    }

    public void resetStatusCounter() {
        if (this.statusThread != null) {
            this.statusThread.resetStatusCounter();
        }
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(String serverAddress, int serverPort) {
        this.setConfiguration(serverAddress, serverPort, new int[]{1}, 1);
    }

    public void setConfiguration(String serverAddress, int serverPort, int[] devices, int activeDevice) {
        this.configuration.setServerAddress(serverAddress);
        this.configuration.setServerPort(serverPort);
        this.configuration.setDevices(devices);
        this.configuration.setActiveDevice(activeDevice);
        this.saveConfiguration(CONFIG_FILEPATH);
    }

    public void loadConfiguration(String filename) {
        try {
            this.configuration.setServerAddress("localhost");
            this.configuration.setServerPort(30000);
            this.configuration.setDevices(new int[]{1});
            this.configuration.setActiveDevice(1);
            File file = new File(filename);
            if (!file.exists()) {
                return;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "UTF8"));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (line.indexOf("address=") == 0) {
                    this.configuration.setServerAddress(line.substring(line.indexOf(61) + 1).trim());
                    continue;
                }
                if (line.indexOf("port=") == 0) {
                    try {
                        this.configuration.setServerPort(Integer.parseInt(line.substring(line.indexOf(61) + 1).trim()));
                    }
                    catch (NumberFormatException e) {
                        this.configuration.setServerPort(30000);
                    }
                    continue;
                }
                if (line.indexOf("devices=") == 0) {
                    int[] devices;
                    if (line.substring(line.indexOf(61) + 1).trim().length() < 1) {
                        devices = new int[]{1};
                    } else {
                        String[] sDevices = line.substring(line.indexOf(61) + 1).trim().split(",");
                        devices = new int[sDevices.length];
                        int i = 0;
                        while (i < devices.length) {
                            try {
                                devices[i] = Integer.parseInt(sDevices[i]);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            ++i;
                        }
                    }
                    this.configuration.setDevices(devices);
                    continue;
                }
                if (line.indexOf("activeDevice=") != 0) continue;
                try {
                    this.configuration.setActiveDevice(Integer.parseInt(line.substring(line.indexOf(61) + 1).trim()));
                }
                catch (NumberFormatException e) {
                    this.configuration.setActiveDevice(1);
                }
            }
            reader.close();
        }
        catch (UnsupportedEncodingException e) {
            return;
        }
        catch (IOException e) {
            return;
        }
    }

    public void saveConfiguration(String filename) {
        try {
            File file = new File(filename);
            FileOutputStream os = new FileOutputStream(file);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)os, "UTF8");
            String ls = System.getProperty("line.separator");
            String[] devices = new String[this.configuration.getDevices().length];
            int i = 0;
            while (i < devices.length) {
                devices[i] = "" + this.configuration.getDevices()[i];
                ++i;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("address=");
            sb.append(this.configuration.getServerAddress());
            sb.append(ls);
            sb.append("port=");
            sb.append(this.configuration.getServerPort());
            sb.append(ls);
            sb.append("devices=");
            StringBuilder sbDevice = new StringBuilder();
            String[] stringArray = devices;
            int n = devices.length;
            int n2 = 0;
            while (n2 < n) {
                String device = stringArray[n2];
                sbDevice.append(",");
                sbDevice.append(device);
                ++n2;
            }
            sb.append(sbDevice.toString().substring(1));
            sb.append(ls);
            sb.append("activeDevice=");
            sb.append(this.configuration.getActiveDevice());
            osw.write(sb.toString());
            osw.close();
        }
        catch (IOException e) {
            return;
        }
    }

    public FiscalModule getFiscalModule() {
        Configuration config = this.getConfiguration();
        return new FiscalModule(config.getServerAddress(), config.getServerPort(), config.getActiveDevice());
    }

    public void setChduPort(String connectionString, int ppekkId) throws Exception {
        SetChduPortRequest request = SetChduPortRequest.getInstance(ppekkId);
        request.setConnectionString(connectionString);
        try {
            SetChduPortResponse response = (SetChduPortResponse)this.commClient.send(request);
            long errorCode = response.getErrorCode();
            if (errorCode == 0L) {
                return;
            }
            if (errorCode == 1L) {
                throw new Exception("Chyba");
            }
            if (errorCode == 2L) {
                throw new Exception("Chyba");
            }
            if (errorCode == 3L) {
                throw new Exception(Localization.getString("client.error.ekasa_" + response.getErrorCodeEkasa()));
            }
            throw new Exception("Chyba");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void loadChduPacket(String path, int count, int ppekkId) throws Exception {
        File dir = new File(path);
        GetChduInfoRequest request = GetChduInfoRequest.getInstance(ppekkId);
        try {
            GetChduInfoResponse response = (GetChduInfoResponse)this.commClient.send(request);
            long errorCode = response.getErrorCode();
            if (errorCode == 0L) {
                Transaction.ID zeroTransactionId = new Transaction.ID(0, 0);
                Transaction.ID transactionId = new Transaction.ID(response.getLastTransactionId());
                int i = 0;
                while (i < count) {
                    FileOutputStream fos;
                    LoadPacketFromChduRequest request1 = LoadPacketFromChduRequest.getInstance((long)ppekkId, transactionId.format());
                    LoadPacketFromChduResponse response1 = (LoadPacketFromChduResponse)this.commClient.send(request1);
                    if (response1.getRequest() != null && response1.getRequest().length > 0) {
                        fos = new FileOutputStream(new File(dir, String.valueOf(transactionId.format()) + ".D"));
                        fos.write(response1.getRequest());
                        fos.close();
                    }
                    if (response1.getResponse() != null && response1.getResponse().length > 0) {
                        fos = new FileOutputStream(new File(dir, String.valueOf(transactionId.format()) + ".R"));
                        fos.write(response1.getResponse());
                        fos.close();
                    }
                    if (response1.getStatus() != null && response1.getStatus().length > 0) {
                        fos = new FileOutputStream(new File(dir, String.valueOf(transactionId.format()) + ".S"));
                        fos.write(response1.getStatus());
                        fos.close();
                    }
                    if (response1.getLpt() != null && response1.getLpt().length > 0) {
                        fos = new FileOutputStream(new File(dir, String.valueOf(transactionId.format()) + ".0"));
                        fos.write(response1.getLpt());
                        fos.close();
                    }
                    transactionId.decrement();
                    if (zeroTransactionId.compareTo(transactionId) > 0) {
                        return;
                    }
                    ++i;
                }
            }
            if (errorCode == 0L) {
                return;
            }
            if (errorCode == 1L) {
                throw new Exception("Chyba");
            }
            if (errorCode == 2L) {
                throw new Exception("Chyba");
            }
            if (errorCode == 3L) {
                throw new Exception(Localization.getString("client.error.ekasa_" + response.getErrorCodeEkasa()));
            }
            throw new Exception("Chyba");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void setSynchronize(boolean ppekk2chdu, int ppekkId) throws Exception {
        SynchronizeRequest request = SynchronizeRequest.getInstance(ppekkId);
        request.setSynchroPpekk2Chdu(ppekk2chdu);
        try {
            SynchronizeResponse response = (SynchronizeResponse)this.commClient.send(request);
            long errorCode = response.getErrorCode();
            if (errorCode == 0L) {
                return;
            }
            if (errorCode == 1L) {
                throw new Exception("Chyba");
            }
            if (errorCode == 2L) {
                throw new Exception("Chyba");
            }
            if (errorCode == 3L) {
                throw new Exception(Localization.getString("client.error.ekasa_" + response.getErrorCodeEkasa()));
            }
            throw new Exception("Chyba");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void sendIdentity(String xml, int ppekkId) throws Exception {
        SetIdentityRequest request = SetIdentityRequest.getInstance(ppekkId);
        request.setXml(xml);
        SetIdentityResponse response = (SetIdentityResponse)this.commClient.send(request);
        long errorCode = response.getErrorCode();
        if (errorCode == 0L) {
            return;
        }
        if (errorCode == 1L) {
            throw new Exception("Chyba");
        }
        if (errorCode == 2L) {
            throw new Exception("Chyba");
        }
        if (errorCode == 3L) {
            throw new Exception(Localization.getString("client.error.ekasa_" + response.getErrorCodeEkasa()));
        }
        throw new Exception("Chyba");
    }

    public void sendAuthentication(String xml, String password, int ppekkId) throws Exception {
        SetAuthenticationRequest request = SetAuthenticationRequest.getInstance(ppekkId);
        request.setXml(xml);
        request.setPassword(password);
        SetAuthenticationResponse response = (SetAuthenticationResponse)this.commClient.send(request);
        long errorCode = response.getErrorCode();
        if (errorCode == 0L) {
            return;
        }
        if (errorCode == 1L) {
            throw new Exception("Chyba");
        }
        if (errorCode == 2L) {
            throw new Exception("Chyba");
        }
        if (errorCode == 3L) {
            throw new Exception(Localization.getString("client.error.ekasa_" + response.getErrorCodeEkasa()));
        }
        throw new Exception("Chyba");
    }

    public void printTestReceipt(int ppekkId) throws Exception {
        TestReceiptRequest request = TestReceiptRequest.getInstance(ppekkId);
        TestReceiptResponse response = (TestReceiptResponse)this.commClient.send(request);
        long errorCode = response.getErrorCode();
        if (errorCode == 0L) {
            return;
        }
        if (errorCode == 1L) {
            throw new Exception("Chyba");
        }
        if (errorCode == 2L) {
            throw new Exception("Chyba");
        }
        if (errorCode == 3L) {
            throw new Exception(Localization.getString("client.error.ekasa_" + response.getErrorCodeEkasa()));
        }
        throw new Exception("Chyba");
    }

    public void cfgQuorionBridgeChdu(int ppekkId) throws Exception {
        CfgQuorionBridgeRequest request = CfgQuorionBridgeRequest.getInstance(ppekkId);
        CfgQuorionBridgeResponse response = (CfgQuorionBridgeResponse)this.commClient.send(request);
        long errorCode = response.getErrorCode();
        if (errorCode == 0L) {
            return;
        }
        if (errorCode == 1L) {
            throw new Exception("Chyba");
        }
        if (errorCode == 2L) {
            throw new Exception("Chyba");
        }
        if (errorCode == 3L) {
            throw new Exception(Localization.getString("client.error.ekasa_" + response.getErrorCodeEkasa()));
        }
        throw new Exception("Chyba");
    }

    public void sendUpgrade(byte[] upgrade, int ppekkId) throws Exception {
        SendUpgradeRequest request = SendUpgradeRequest.getInstance(ppekkId);
        request.setUpgrade(upgrade);
        SendUpgradeResponse response = (SendUpgradeResponse)this.commClient.send(request);
        long errorCode = response.getErrorCode();
        if (errorCode == 0L) {
            return;
        }
        if (errorCode == 1L) {
            throw new Exception("Chyba");
        }
        if (errorCode == 2L) {
            throw new Exception("Chyba");
        }
        if (errorCode == 3L) {
            throw new Exception(Localization.getString("client.error.ekasa_" + response.getErrorCodeEkasa()));
        }
        throw new Exception("Chyba");
    }

    public GetCertificateValidResponse checkStatus(int ppekkId) throws Exception {
        try {
            GetCertificateValidRequest request = GetCertificateValidRequest.getInstance(ppekkId);
            GetCertificateValidResponse response = (GetCertificateValidResponse)this.commClient.send(request);
            long errorCode = response.getErrorCode();
            if (errorCode == 0L) {
                return response;
            }
            if (errorCode == 1L) {
                throw new Exception("Chyba");
            }
            if (errorCode == 2L) {
                throw new Exception("Chyba");
            }
            if (errorCode == 3L) {
                throw new Exception(Localization.getString("client.error.ekasa_" + response.getErrorCodeEkasa()));
            }
            throw new Exception("Chyba");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public GetChduStateResponse getChduState(int ppekkId) throws Exception {
        try {
            GetChduStateRequest request = GetChduStateRequest.getInstance(ppekkId);
            GetChduStateResponse response = (GetChduStateResponse)this.commClient.send(request);
            long errorCode = response.getErrorCode();
            System.out.println("GET_CHDU_STATE errorCode=" + errorCode);
            System.out.println("GET_CHDU_STATE errorCodeEKasa=" + response.getErrorCodeEkasa());
            if (errorCode == 0L) {
                return response;
            }
            if (errorCode == 1L) {
                this.serverConnected(false);
                throw new Exception("Chyba");
            }
            if (errorCode == 2L) {
                this.serverConnected(true);
                throw new Exception("Chyba");
            }
            if (errorCode == 3L) {
                this.serverConnected(true);
                throw new Exception(Localization.getString("client.error.ekasa_" + response.getErrorCodeEkasa()));
            }
            this.serverConnected(false);
            throw new Exception("Chyba");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.serverConnected(false);
            throw e;
        }
    }

    public GetChduInfoResponse getChduInfo(int ppekkId) throws Exception {
        GetChduInfoRequest request = GetChduInfoRequest.getInstance(ppekkId);
        GetChduInfoResponse response = (GetChduInfoResponse)this.commClient.send(request);
        long errorCode = response.getErrorCode();
        if (errorCode == 0L) {
            return response;
        }
        if (errorCode == 1L) {
            throw new Exception("Chyba");
        }
        if (errorCode == 2L) {
            throw new Exception("Chyba");
        }
        if (errorCode == 3L) {
            throw new Exception(Localization.getString("client.error.ekasa_" + response.getErrorCodeEkasa()));
        }
        throw new Exception("Chyba");
    }

    public GetPpekkInfoResponse getPpekkInfo(int ppekkId) throws Exception {
        GetPpekkInfoRequest request = GetPpekkInfoRequest.getInstance(ppekkId);
        GetPpekkInfoResponse response = (GetPpekkInfoResponse)this.commClient.send(request);
        long errorCode = response.getErrorCode();
        if (errorCode == 0L) {
            return response;
        }
        if (errorCode == 1L) {
            throw new Exception("Chyba");
        }
        if (errorCode == 2L) {
            throw new Exception("Chyba");
        }
        if (errorCode == 3L) {
            throw new Exception(Localization.getString("client.error.ekasa_" + response.getErrorCodeEkasa()));
        }
        throw new Exception("Chyba");
    }

    public GetPpekkRs232PortResponse getPpekkRs232Port(int ppekkId) throws Exception {
        GetPpekkRs232PortRequest request = GetPpekkRs232PortRequest.getInstance(ppekkId);
        GetPpekkRs232PortResponse response = (GetPpekkRs232PortResponse)this.commClient.send(request);
        long errorCode = response.getErrorCode();
        if (errorCode == 0L) {
            return response;
        }
        if (errorCode == 1L) {
            throw new Exception("Chyba");
        }
        if (errorCode == 2L) {
            throw new Exception("Chyba");
        }
        if (errorCode == 3L) {
            throw new Exception(Localization.getString("client.error.ekasa_" + response.getErrorCodeEkasa()));
        }
        throw new Exception("Chyba");
    }

    public GetUnsendedMessageResponse getUnsendedMessage(int ppekkId) throws Exception {
        GetUnsendedMessageRequest request = GetUnsendedMessageRequest.getInstance(ppekkId);
        GetUnsendedMessageResponse response = (GetUnsendedMessageResponse)this.commClient.send(request);
        long errorCode = response.getErrorCode();
        if (errorCode == 0L) {
            return response;
        }
        if (errorCode == 1L) {
            throw new Exception("Chyba");
        }
        if (errorCode == 2L) {
            throw new Exception("Chyba");
        }
        if (errorCode == 3L) {
            throw new Exception(Localization.getString("client.error.ekasa_" + response.getErrorCodeEkasa()));
        }
        throw new Exception("Chyba");
    }

    public GetCertificateValidResponse getCertificateValid(int ppekkId) throws Exception {
        GetCertificateValidRequest request = GetCertificateValidRequest.getInstance(ppekkId);
        GetCertificateValidResponse response = (GetCertificateValidResponse)this.commClient.send(request);
        long errorCode = response.getErrorCode();
        if (errorCode == 0L) {
            return response;
        }
        if (errorCode == 1L) {
            throw new Exception("Chyba");
        }
        if (errorCode == 2L) {
            throw new Exception("Chyba");
        }
        if (errorCode == 3L) {
            throw new Exception(Localization.getString("client.error.ekasa_" + response.getErrorCodeEkasa()));
        }
        throw new Exception("Chyba");
    }

    public PrintUnsendedMessageResponse printUnsendedMessage(int ppekkId, String dateFrom, String dateTo, String numberFrom, String numberTo) throws Exception {
        PrintUnsendedMessageRequest request = PrintUnsendedMessageRequest.getInstance(ppekkId);
        request.setDateFrom(dateFrom);
        request.setDateTo(dateTo);
        request.setNumberFrom(numberFrom);
        request.setNumberTo(numberTo);
        PrintUnsendedMessageResponse response = (PrintUnsendedMessageResponse)this.commClient.send(request);
        long errorCode = response.getErrorCode();
        if (errorCode == 0L) {
            return response;
        }
        if (errorCode == 1L) {
            throw new Exception("Chyba");
        }
        if (errorCode == 2L) {
            throw new Exception("Chyba");
        }
        if (errorCode == 3L) {
            throw new Exception(Localization.getString("client.error.ekasa_" + response.getErrorCodeEkasa()));
        }
        throw new Exception("Chyba");
    }

    public PrintLastReceiptCopyMessageResponse printLastReceiptCopyMessage(int ppekkId) throws Exception {
        PrintLastReceiptCopyMessageRequest request = PrintLastReceiptCopyMessageRequest.getInstance(ppekkId);
        PrintLastReceiptCopyMessageResponse response = (PrintLastReceiptCopyMessageResponse)this.commClient.send(request);
        long errorCode = response.getErrorCode();
        if (errorCode == 0L) {
            return response;
        }
        if (errorCode == 1L) {
            throw new Exception("Chyba");
        }
        if (errorCode == 2L) {
            throw new Exception("Chyba");
        }
        if (errorCode == 3L) {
            throw new Exception(Localization.getString("client.error.ekasa_" + response.getErrorCodeEkasa()));
        }
        throw new Exception("Chyba");
    }

    public SendUnsendedMessageResponse sendUnsendedMessage(int ppekkId) throws Exception {
        SendUnsendedMessageRequest request = SendUnsendedMessageRequest.getInstance(ppekkId);
        SendUnsendedMessageResponse response = (SendUnsendedMessageResponse)this.commClient.send(request);
        long errorCode = response.getErrorCode();
        if (errorCode == 0L) {
            return response;
        }
        if (errorCode == 1L) {
            throw new Exception("Chyba");
        }
        if (errorCode == 2L) {
            throw new Exception("Chyba");
        }
        if (errorCode == 3L) {
            throw new Exception(Localization.getString("client.error.ekasa_" + response.getErrorCodeEkasa()));
        }
        throw new Exception("Chyba");
    }

    public void connectChdu(int ppekkId) throws Exception {
        ChduConnectRequest request = ChduConnectRequest.getInstance(ppekkId);
        ChduConnectResponse response = (ChduConnectResponse)this.commClient.send(request);
        long errorCode = response.getErrorCode();
        if (errorCode == 0L) {
            return;
        }
        if (errorCode == 1L) {
            throw new Exception("Chyba");
        }
        if (errorCode == 2L) {
            throw new Exception("Chyba");
        }
        if (errorCode == 3L) {
            throw new Exception(Localization.getString("client.error.ekasa_" + response.getErrorCodeEkasa()));
        }
        throw new Exception("Chyba");
    }

    public void disconnectChdu(int ppekkId) throws Exception {
        ChduDisconnectRequest request = ChduDisconnectRequest.getInstance(ppekkId);
        ChduDisconnectResponse response = (ChduDisconnectResponse)this.commClient.send(request);
        long errorCode = response.getErrorCode();
        if (errorCode == 0L) {
            return;
        }
        if (errorCode == 1L) {
            throw new Exception("Chyba");
        }
        if (errorCode == 2L) {
            throw new Exception("Chyba");
        }
        if (errorCode == 3L) {
            throw new Exception(Localization.getString("client.error.ekasa_" + response.getErrorCodeEkasa()));
        }
        throw new Exception("Chyba");
    }

    public SetProxyResponse setProxy(boolean enabled) throws Exception {
        SetProxyRequest request = SetProxyRequest.getInstance(this.getConfiguration().getActiveDevice(), enabled, this.proxyHost, this.proxyPort);
        SetProxyResponse response = (SetProxyResponse)this.commClient.send(request);
        long errorCode = response.getErrorCode();
        if (errorCode == 0L) {
            return response;
        }
        if (errorCode == 1L) {
            throw new Exception("Chyba");
        }
        if (errorCode == 2L) {
            throw new Exception("Chyba");
        }
        if (errorCode == 3L) {
            throw new Exception(Localization.getString("client.error.ekasa_" + response.getErrorCodeEkasa()));
        }
        throw new Exception("Chyba");
    }

    public void showAlert(String msg) {
        if (this.trayIcon != null) {
            this.trayIcon.displayMessage(Localization.getString("client.message.alert"), msg, 2);
        }
    }

    public void showError(String msg) {
        if (this.trayIcon != null) {
            this.trayIcon.displayMessage(Localization.getString("client.message.error"), msg, 1);
        }
    }

    public void storePpekkInfo(int ppekkId, GetPpekkInfoResponse response) {
        this.ppekkInfo.put(ppekkId, response);
        for (PpekkStateListener listener : this.ppekkStateListeners) {
            listener.ppekkInfoChanged();
        }
    }

    public GetPpekkInfoResponse restorePpekkInfo(int ppekkId) {
        return this.ppekkInfo.get(ppekkId);
    }

    public void setChduState(String connected, boolean transmitted, boolean received, String transactionId, boolean isProxy) {
        for (PpekkStateListener listener : this.ppekkStateListeners) {
            listener.chduStateChanged(connected, transmitted, received, transactionId);
        }
        if (this.proxyHost != null) {
            this.trayIcon.setProxy(isProxy);
        }
    }

    public String getProxyAddress() {
        return this.proxyHost;
    }

    public void setProxyAddress(String proxyAddress) {
        this.proxyHost = proxyAddress;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public void openPPEKKWindow() {
        if (this.ppekkWindow == null) {
            this.ppekkWindow = new PPEKKWindow(this);
        }
        if (!this.ppekkWindow.isVisible()) {
            this.ppekkWindow.setDefaultTab();
            this.ppekkWindow.setVisible(true);
        }
    }

    public boolean isPPEKKWindowOpened() {
        return this.ppekkWindow == null ? false : this.ppekkWindow.isVisible();
    }

    public static enum CONNECTION_STATE {
        CONNECTED,
        DISCONNECTED;

    }
}

