/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.client.application;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.client.application.CommunicationClient;
import sk.singularisdev.ekasask.client.application.Controller;
import sk.singularisdev.ekasask.client.localization.Localization;
import sk.singularisdev.ekasask.client.packet.GetCertificateValidResponse;
import sk.singularisdev.ekasask.client.packet.GetChduStateResponse;
import sk.singularisdev.ekasask.client.packet.GetPpekkInfoResponse;
import sk.singularisdev.ekasask.utils.Utility;

public class StatusThread
implements Runnable {
    private static final Logger logger = LoggerManager.getLogger((String)StatusThread.class.getName());
    private Controller controller;
    private CommunicationClient commClient;
    private Thread thread = null;
    private boolean running = false;
    private boolean stopSignal = false;
    private Map<Integer, AuthValid> authValids = new HashMap<Integer, AuthValid>();
    private long lastCertInfoTime = 0L;

    public StatusThread(Controller controller, CommunicationClient commClient) {
        this.controller = controller;
        this.commClient = commClient;
    }

    @Override
    public void run() {
        this.running = true;
        this.stopSignal = false;
        try {
            long lastPpekkInfo = 0L;
            boolean lastIsPPEKKWindowOpened = false;
            while (!this.stopSignal) {
                try {
                    if (!this.commClient.isConnected()) {
                        this.commClient.connect();
                        lastPpekkInfo = 0L;
                    }
                    System.out.println("COMMCLIENT: " + this.commClient.isConnected());
                    if (this.commClient.isConnected()) {
                        if (!Utility.arrayContains((int[])this.controller.getConfiguration().getDevices(), (int)this.controller.getConfiguration().getActiveDevice())) {
                            return;
                        }
                        int ppekkId = this.controller.getConfiguration().getActiveDevice();
                        if (this.controller.isPPEKKWindowOpened()) {
                            System.out.println("STATUS_THREAD: getChduState(" + ppekkId + ")   [Start]");
                            GetChduStateResponse r1 = this.controller.getChduState(ppekkId);
                            System.out.println("STATUS_THREAD: getChduState(" + ppekkId + ")   [End]");
                            String x = "";
                            x = r1.isConnected() ? Localization.getString("client.send.status.chdu_connection.connected") : Localization.getString("client.send.status.chdu_connection.disconnected");
                            this.controller.setChduState(x, r1.isTransmitted(), r1.isReceived(), r1.getTransactionId(), r1.isProxy());
                            if (!lastIsPPEKKWindowOpened || System.currentTimeMillis() - lastPpekkInfo > 600000L) {
                                GetPpekkInfoResponse response = this.controller.getPpekkInfo(ppekkId);
                                this.controller.storePpekkInfo(ppekkId, response);
                            }
                        }
                        lastIsPPEKKWindowOpened = this.controller.isPPEKKWindowOpened();
                        if (System.currentTimeMillis() - this.lastCertInfoTime > 3600000L) {
                            this.lastCertInfoTime = System.currentTimeMillis();
                            GetCertificateValidResponse status = this.controller.checkStatus(ppekkId);
                            long errorCode = status.getErrorCode();
                            if (errorCode == 0L) {
                                AuthValid oldAuthValid;
                                this.controller.serverConnected(true);
                                if (this.authValids.containsKey(ppekkId)) {
                                    oldAuthValid = this.authValids.get(ppekkId);
                                } else {
                                    oldAuthValid = new AuthValid();
                                    oldAuthValid.validTo = new Date(0L);
                                    oldAuthValid.lastValidTime = 0L;
                                }
                                if (!oldAuthValid.validTo.equals(status.getCertificateValid()) || oldAuthValid.lastValidTime < System.currentTimeMillis() - 3600000L) {
                                    AuthValid authValid = new AuthValid();
                                    authValid.validTo = status.getCertificateValid();
                                    authValid.lastValidTime = System.currentTimeMillis();
                                    this.authValids.put(ppekkId, authValid);
                                    Calendar today = Calendar.getInstance();
                                    Calendar valid = Calendar.getInstance();
                                    valid.setTime(authValid.validTo);
                                    today.add(5, 30);
                                    if (valid.before(today)) {
                                        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.YYYY");
                                        this.controller.showAlert(Localization.getString("client.message.status.certificate_valid_Date", new String[]{"{DATUM}", "{PPEKK_ID}"}, new String[]{sdf.format(authValid.validTo), "" + ppekkId}));
                                    }
                                }
                            } else if (errorCode == 1L) {
                                this.controller.serverConnected(false);
                            } else if (errorCode == 2L) {
                                this.controller.showError(Localization.getString("client.send.error.no_chdu", new String[]{"{PPEKK_ID}"}, new String[]{"" + ppekkId}));
                            } else if (errorCode == 3L) {
                                this.controller.showError(Localization.getString("client.send.error.ppekk_" + status.getErrorCodeEkasa(), new String[]{"{PPEKK_ID}"}, new String[]{"" + ppekkId}));
                            }
                            lastPpekkInfo = System.currentTimeMillis();
                        }
                    } else {
                        this.controller.setChduState("", false, false, "", false);
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.running = false;
    }

    public synchronized void startThread() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    public synchronized void stopThread() {
        this.stopSignal = true;
        this.thread.interrupt();
        while (this.running) {
            try {
                Thread.sleep(5L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void resetStatusCounter() {
        this.lastCertInfoTime = 0L;
    }

    private class AuthValid {
        private Date validTo;
        private long lastValidTime;

        private AuthValid() {
        }
    }
}

