/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.client.packet;

import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.client.packet.AbstractPacketRequest;
import sk.singularisdev.ekasask.client.packet.AbstractPacketResponse;
import sk.singularisdev.ekasask.client.packet.TestReceiptResponse;
import sk.singularisdev.ekasask.command.AbstractCommand;
import sk.singularisdev.ekasask.command.InvalidReceipt;
import sk.singularisdev.ekasask.command.ItemPrint;
import sk.singularisdev.ekasask.command.MessageItemInterfaceParagon;
import sk.singularisdev.ekasask.command.ReceiptItemSale;
import sk.singularisdev.ekasask.enumeration.VAT_LEVEL;

public class TestReceiptRequest
extends AbstractPacketRequest {
    public static final byte[] COMMAND = new byte[]{1, 18};
    public static final String PARAMETER_DATE = "Date";

    private TestReceiptRequest(long ppekkId) {
        super(ppekkId);
        SimpleDateFormat sdf = new SimpleDateFormat("MMddHHmmyyyy.ss");
        this.data.put(PARAMETER_DATE, sdf.format(new Date()));
    }

    public static TestReceiptRequest getInstance(long ppekkId) {
        TestReceiptRequest r = new TestReceiptRequest(ppekkId);
        return r;
    }

    public static TestReceiptRequest getInstance(long ppekkId, byte[] data) {
        TestReceiptRequest r = new TestReceiptRequest(ppekkId);
        r.deserializeParam(data);
        return r;
    }

    @Override
    public AbstractPacketResponse process() {
        TestReceiptResponse response = new TestReceiptResponse(this.ppekkId);
        try {
            PPEKK ppekk = PPEKK.install((long)this.ppekkId, (String)"AA1");
            if (ppekk == null) {
                response.setErrorCode(2L);
            }
            Runtime.getRuntime().exec(new String[]{"date", (String)this.data.get(PARAMETER_DATE)});
            InvalidReceipt receipt = InvalidReceipt.getInstance();
            Date date = new Date();
            receipt.setCreateDate(date);
            receipt.setIssueDate(date);
            receipt.setBasicVatAmount(189L);
            receipt.setTaxBaseBasic(947L);
            ReceiptItemSale item = ReceiptItemSale.getInstance((String)"Testovacia polo\u017eka 1", (BigDecimal)new BigDecimal("1.23"), (BigDecimal)new BigDecimal(2), (String)"x", (long)246L, (VAT_LEVEL)VAT_LEVEL.A);
            receipt.addItem((MessageItemInterfaceParagon)item);
            item = ReceiptItemSale.getInstance((String)"Testovacia polo\u017eka 2", (BigDecimal)new BigDecimal("0.89"), (BigDecimal)new BigDecimal(10), (String)"x", (long)890L, (VAT_LEVEL)VAT_LEVEL.A);
            receipt.addItem((MessageItemInterfaceParagon)item);
            int charPerRow = ppekk.getPrinter().getCharPerRow();
            String text = "Hotovos\u0165 EUR ";
            ItemPrint payment = ItemPrint.getInstance((String)(String.valueOf(text) + String.format("%1$" + (charPerRow - text.length()) + "s", "15.00")));
            receipt.addPayment((MessageItemInterfaceParagon)payment);
            text = "Vr\u00e1ten\u00e9 EUR ";
            payment = ItemPrint.getInstance((String)(String.valueOf(text) + String.format("%1$" + (charPerRow - text.length()) + "s", "3.64")));
            receipt.addPayment((MessageItemInterfaceParagon)payment);
            ppekk.process((AbstractCommand)receipt);
            response.setErrorCode(0L);
        }
        catch (IOException e) {
            response.setErrorCode(3L);
            response.setErrorCodeEkasa(-1111111L);
        }
        catch (EKasaException e) {
            response.setErrorCode(3L);
            response.setErrorCodeEkasa(e.getErrorCode());
        }
        return response;
    }

    @Override
    public byte[] getCommand() {
        return COMMAND;
    }
}

