/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.client.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.LineBorder;
import sk.singularisdev.ekasask.client.application.Controller;
import sk.singularisdev.ekasask.client.application.PpekkStateListener;
import sk.singularisdev.ekasask.client.localization.Localization;
import sk.singularisdev.ekasask.client.packet.GetPpekkInfoResponse;
import sk.singularisdev.ekasask.client.ui.DisabledPanel;
import sk.singularisdev.ekasask.client.ui.PPEKKWindowAuthPanel;
import sk.singularisdev.ekasask.client.ui.PPEKKWindowChduConnectionPanel;
import sk.singularisdev.ekasask.client.ui.PPEKKWindowFmPanel;
import sk.singularisdev.ekasask.client.ui.PPEKKWindowFmPanel2;
import sk.singularisdev.ekasask.client.ui.PPEKKWindowIdentPanel;
import sk.singularisdev.ekasask.client.ui.PPEKKWindowPpekkChduStatePanel;
import sk.singularisdev.ekasask.client.ui.PPEKKWindowSynchroPanel;
import sk.singularisdev.ekasask.utils.Utility;

public class PPEKKWindow
extends JFrame
implements WindowListener,
PpekkStateListener {
    private JTabbedPane tabbedPane;
    private JLabel lblCHDUConnection;
    private JLabel lblCHDUTransmit;
    private JLabel lblCHDUReceive;
    private JLabel lblVersion;
    private JLabel lblTimeZone = new JLabel();
    private ImageIcon iconSuccess;
    private ImageIcon iconFail;
    private ImageIcon iconCommunicate;
    private ImageIcon iconNoCommunicate;
    private DisabledPanel disabledPanel;
    private Controller controller;
    private PPEKKWindowChduConnectionPanel panelChduConnection;
    private PPEKKWindowFmPanel panelFm;
    private PPEKKWindowFmPanel2 panelFm2;

    public PPEKKWindow(Controller controller) {
        this(controller, false);
    }

    public PPEKKWindow(Controller controller, boolean exitAppAfterClose) {
        this.controller = controller;
        this.init(exitAppAfterClose);
    }

    private void init(boolean exitAppAfterClose) {
        if (exitAppAfterClose) {
            this.addWindowListener(this);
        }
        this.iconSuccess = new ImageIcon(PPEKKWindow.class.getResource("/sk/singularisdev/ekasask/client/application/upload_success.png"));
        this.iconFail = new ImageIcon(PPEKKWindow.class.getResource("/sk/singularisdev/ekasask/client/application/upload_failed.png"));
        this.iconCommunicate = new ImageIcon(PPEKKWindow.class.getResource("/sk/singularisdev/ekasask/client/application/communicate.png"));
        this.iconNoCommunicate = new ImageIcon(PPEKKWindow.class.getResource("/sk/singularisdev/ekasask/client/application/no_communicate.png"));
        this.setTitle(Localization.getString("client.send.title"));
        JPanel mainPanel = new JPanel(new BorderLayout());
        this.disabledPanel = new DisabledPanel(mainPanel);
        this.add(this.disabledPanel);
        this.panelChduConnection = new PPEKKWindowChduConnectionPanel(this.controller, this);
        this.setBounds(100, 100, 840, 500);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setBorder(new LineBorder(Color.GRAY));
        this.tabbedPane.addTab(Localization.getString("client.send.chdu_connection"), this.panelChduConnection);
        this.tabbedPane.addTab(Localization.getString("client.send.authdata"), new PPEKKWindowAuthPanel(this.controller, this));
        this.tabbedPane.addTab(Localization.getString("client.send.iddata"), new PPEKKWindowIdentPanel(this.controller, this));
        this.tabbedPane.addTab(Localization.getString("client.send.statedata"), new PPEKKWindowPpekkChduStatePanel(this.controller, this));
        this.tabbedPane.addTab(Localization.getString("client.send.synchro"), new PPEKKWindowSynchroPanel(this.controller, this));
        this.panelFm2 = new PPEKKWindowFmPanel2(this.controller, this);
        this.panelFm = new PPEKKWindowFmPanel(this.controller, this);
        if (!Controller.QUORION_BRIDGE) {
            this.tabbedPane.addTab(Localization.getString("client.send.fm"), this.panelFm);
            this.tabbedPane.addTab(Localization.getString("client.send.fm2"), this.panelFm2);
        }
        mainPanel.add((Component)this.tabbedPane, "Center");
        JPanel panelStatus = new JPanel(null);
        mainPanel.add((Component)panelStatus, "South");
        panelStatus.setPreferredSize(new Dimension(0, 20));
        JLabel lblCHDUConnectionTitle = new JLabel(String.valueOf(Localization.getString("client.send.status.chdu_connection")) + ":");
        lblCHDUConnectionTitle.setBounds(105, 0, 100, 20);
        panelStatus.add(lblCHDUConnectionTitle);
        this.lblCHDUConnection = new JLabel("");
        this.lblCHDUConnection.setBounds(205, 0, 150, 20);
        panelStatus.add(this.lblCHDUConnection);
        this.lblCHDUTransmit = new JLabel();
        this.lblCHDUTransmit.setToolTipText(Localization.getString("client.send.status.transmit"));
        this.lblCHDUTransmit.setBounds(5, 0, 20, 20);
        panelStatus.add((Component)this.lblCHDUTransmit, "East");
        this.lblCHDUReceive = new JLabel();
        this.lblCHDUReceive.setToolTipText(Localization.getString("client.send.status.receive"));
        this.lblCHDUReceive.setBounds(25, 0, 20, 20);
        panelStatus.add((Component)this.lblCHDUReceive, "East");
        JLabel lblVersion = new JLabel("BOWA EKasa v1.1b27");
        lblVersion.setBounds(400, 0, 200, 20);
        panelStatus.add(lblVersion);
        this.lblTimeZone.setBounds(600, 0, 200, 20);
        panelStatus.add(this.lblTimeZone);
        this.setVisible(true);
        this.controller.addPpekkStateListener(this);
    }

    public PPEKKWindowFmPanel getPanelFm() {
        return this.panelFm;
    }

    public PPEKKWindowFmPanel2 getPanelFm2() {
        return this.panelFm2;
    }

    public void setDefaultTab() {
        if (this.tabbedPane != null) {
            this.tabbedPane.setSelectedIndex(0);
        }
    }

    public void showSuccessIcon(JLabel label, boolean show, boolean success, String msg) {
        label.setIcon(success ? this.iconSuccess : this.iconFail);
        label.setToolTipText(success ? "" : (msg == null ? "" : msg));
        label.setVisible(show);
    }

    public void setChduStatus(boolean connected, boolean transmit, boolean receive, String transactionId) {
    }

    public void processing(boolean processing) {
        this.disabledPanel.setEnabled(!processing);
    }

    @Override
    public void ppekkInfoChanged() {
        this.panelChduConnection.ppekkInfoChanged();
        if (!Utility.arrayContains((int[])this.controller.getConfiguration().getDevices(), (int)this.controller.getConfiguration().getActiveDevice())) {
            return;
        }
        GetPpekkInfoResponse ppekkInfo = this.controller.restorePpekkInfo(this.controller.getConfiguration().getActiveDevice());
        if (ppekkInfo == null) {
            this.lblTimeZone.setText("");
        } else {
            this.lblTimeZone.setText(ppekkInfo.getTimezone());
        }
    }

    @Override
    public void chduStateChanged(String connected, boolean transmit, boolean receive, String transactionId) {
        System.out.println("Status bar setup: CONNECTED=" + connected + "    TRANSMIT=" + transmit + "   RECEIVE=" + receive + "     TRANSACTIONID=" + transactionId);
        this.lblCHDUConnection.setText(connected);
        if (transmit) {
            this.lblCHDUTransmit.setIcon(this.iconCommunicate);
        } else {
            this.lblCHDUTransmit.setIcon(this.iconNoCommunicate);
        }
        if (receive) {
            this.lblCHDUReceive.setIcon(this.iconCommunicate);
        } else {
            this.lblCHDUReceive.setIcon(this.iconNoCommunicate);
        }
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
        this.controller.exit();
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
        this.dispose();
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }
}

